/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.tab.csv;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.tab.TabularWriter;
import cz.insophy.inplan.tab.csv.CsvSettings;
import cz.insophy.inplan.util.NameUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.csv.CSVPrinter;

public abstract class CsvsWriter
implements TabularWriter {
    private final DecimalFormat numberFormat;
    private final DateFormat dateTimeFormat;

    public CsvsWriter(DecimalFormat numberFormat, DateFormat dateTimeFormat) {
        this.numberFormat = numberFormat;
        this.dateTimeFormat = dateTimeFormat;
    }

    @Override
    public <T> TabularWriter.RowsWriter<T> writeTo(Class<T> cls) {
        try {
            String csvName = "DATA_OUT_" + NameUtils.toConstantCase(cls.getSimpleName());
            return new CsvRowsWriter<T>(cls, this.openCsv(csvName));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    abstract CSVPrinter openCsv(@Nonnull String var1) throws IOException;

    public static CsvsWriter toDirectory(final @Nonnull Path path) {
        Preconditions.checkNotNull(path, "path");
        return new CsvsWriter(CsvSettings.getNumberFormat(), CsvSettings.getDateTimeFormat()){

            @Override
            public CSVPrinter openCsv(@Nonnull String name) throws IOException {
                Preconditions.checkNotNull(name, "name");
                return new CSVPrinter(Files.newBufferedWriter(path.resolve(name.toLowerCase() + ".csv"), CsvSettings.getCharset(), new OpenOption[0]), CsvSettings.getCsvFormat());
            }
        };
    }

    public static CsvsWriter toMap(final @Nonnull Map<String, byte[]> out) {
        Preconditions.checkNotNull(out, "map");
        return new CsvsWriter(CsvSettings.getNumberFormat(), CsvSettings.getDateTimeFormat()){

            @Override
            public CSVPrinter openCsv(final @Nonnull String name) throws IOException {
                Preconditions.checkNotNull(name);
                ByteArrayOutputStream baos = new ByteArrayOutputStream(){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        out.put(name, this.toByteArray());
                    }
                };
                return new CSVPrinter(new OutputStreamWriter((OutputStream)baos, CsvSettings.getCharset()), CsvSettings.getCsvFormat());
            }
        };
    }

    private class CsvRowsWriter<T>
    implements TabularWriter.RowsWriter<T> {
        private final Class<T> cls;
        private final CSVPrinter csv;
        private final List<String> record;

        public CsvRowsWriter(Class<T> cls, CSVPrinter csv) {
            this.cls = cls;
            this.csv = csv;
            this.record = new ArrayList<String>(cls.getFields().length);
            this.writeHeader();
        }

        private void writeHeader() {
            for (Field field : this.cls.getFields()) {
                this.record.add(NameUtils.toUnderscoreCase(field.getName()));
            }
            this.writeRecord();
        }

        @Override
        public void writeRow(T data) {
            for (Field field : this.cls.getFields()) {
                try {
                    String s2 = "";
                    Object v = field.get(data);
                    if (v instanceof Long) {
                        Long l = (Long)v;
                        if (GeneralizedRequest.isDateValid(l)) {
                            s2 = CsvsWriter.this.dateTimeFormat.format(l);
                        }
                    } else if (v instanceof Double) {
                        s2 = CsvsWriter.this.numberFormat.format((Double)v);
                    } else if (v != null) {
                        s2 = v.toString();
                    }
                    this.record.add(s2);
                }
                catch (IllegalAccessException e) {
                    this.record.add("ERR");
                }
            }
            this.writeRecord();
        }

        private void writeRecord() {
            try {
                this.csv.printRecord(this.record);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.record.clear();
            }
        }

        @Override
        public void close() {
            try {
                this.csv.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

